// Copyright 1993 by Jon Dart.  All Rights Reserved.

#include "stdafx.h"
#include "hint.h"
#include "search.h"
#include "globals.h"
#include "notation.h"
#include "util.h"

void HintDialog::compute_hint()
{
    // we keep a list of the hint moves generated so far.
    if (!moves[next_move].IsNull())
    {
        hintMove = moves[next_move];
    }
    else
    {    
        num_moves = opening_book->book_moves(the_board,moves,
                        Constants::MAX_HINT_MOVES);
        if (!num_moves)
        {
            // no book move, must search:
            Search searcher;
            BeginWaitCursor();
            num_moves = searcher.hints(the_board,moves,
                Constants::MAX_HINT_MOVES);
            EndWaitCursor();
        }
        hintMove = moves[0];
    }
    if (!hintMove.IsNull())
    {
        char result[20];
        Notation::Image(the_board,hintMove,result);
        m_HintText = result;
        UpdateData(FALSE);
        ++next_move;
        if (next_move >= num_moves) next_move = 0;
    }
}


/////////////////////////////////////////////////////////////////////////////
// HintDialog dialog


HintDialog::HintDialog(CWnd* pParent, Board &board)
        : CDialog(HintDialog::IDD, pParent),
          the_board(board),
          num_moves(0),
          next_move(0)
{
        //{{AFX_DATA_INIT(HintDialog)
        m_HintText = "";
        //}}AFX_DATA_INIT
}

void HintDialog::DoDataExchange(CDataExchange* pDX)
{
        CDialog::DoDataExchange(pDX);
        //{{AFX_DATA_MAP(HintDialog)
        DDX_Text(pDX, ID_HINT_TEXT, m_HintText);
        //}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(HintDialog, CDialog)
        //{{AFX_MSG_MAP(HintDialog)
        ON_BN_CLICKED(ID_ANOTHER, OnAnother)
        //}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// HintDialog message handlers

void HintDialog::OnAnother()
{
    compute_hint();
}

BOOL HintDialog::OnInitDialog()
{
    CDialog::OnInitDialog();

    compute_hint();        
    return TRUE;  // return TRUE  unless you set the focus to a control
}
